<?php

namespace App;

class Product extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;

	public function god()
	{
		return $this->belongsTo('God');
	}

	public function purchases()
	{
		return $this->hasMany('Purchase');
	}

	public function investments()
	{
		return $this->hasMany('Investment');
	}

	public function investors()
	{
		return $this->belongsToMany('Investor', 'investments')->withPivot('bid_price','num_shares');
	}

}