<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'user';
    public $timestamps = true;
    protected $fillable = array('name', 'username');

    public function unit()
    {
        return $this->belongsTo('App\Unit', 'personnel_area', 'personnel_area');
    }

    public function has_role()
    {
        return $this->hasMany('App\UserHasRole', 'user_id', 'id');
    }

}