<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function persona()
	{
		return $this->hasOne('Persona');
	}

	public function concesiones()
	{
		return $this->belongsTo('Concesion');
	}

	public function tramites()
	{
		return $this->belongsTo('Tramite');
	}

	public function suscripciones()
	{
		return $this->belongsTo('Suscripcion');
	}

	public function pagos()
	{
		return $this->belongsTo('Pago');
	}

	public function misconcesiones()
	{
		return $this->hasManyThrough('Concesion', 'ConcesionConcesionario');
	}

}