<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('designation_id')->references('id')->on('designations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('organizations', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('addresses', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('stores', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('contacts', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('emegency_contacts', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('team_staff_members', function(Blueprint $table) {
			$table->foreign('supervisor_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('team_staff_members', function(Blueprint $table) {
			$table->foreign('team_name_id')->references('id')->on('team_names')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('team_staff_members', function(Blueprint $table) {
			$table->foreign('wage_rate_id')->references('id')->on('wage_rates')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('team_staff_members', function(Blueprint $table) {
			$table->foreign('commission_id')->references('id')->on('commissions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_designation_id_foreign');
		});
		Schema::table('organizations', function(Blueprint $table) {
			$table->dropForeign('organizations_user_id_foreign');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->dropForeign('companies_user_id_foreign');
		});
		Schema::table('addresses', function(Blueprint $table) {
			$table->dropForeign('addresses_user_id_foreign');
		});
		Schema::table('stores', function(Blueprint $table) {
			$table->dropForeign('stores_company_id_foreign');
		});
		Schema::table('contacts', function(Blueprint $table) {
			$table->dropForeign('contacts_user_id_foreign');
		});
		Schema::table('emegency_contacts', function(Blueprint $table) {
			$table->dropForeign('emegency_contacts_user_id_foreign');
		});
		Schema::table('team_staff_members', function(Blueprint $table) {
			$table->dropForeign('team_staff_members_supervisor_id_foreign');
		});
		Schema::table('team_staff_members', function(Blueprint $table) {
			$table->dropForeign('team_staff_members_team_name_id_foreign');
		});
		Schema::table('team_staff_members', function(Blueprint $table) {
			$table->dropForeign('team_staff_members_wage_rate_id_foreign');
		});
		Schema::table('team_staff_members', function(Blueprint $table) {
			$table->dropForeign('team_staff_members_commission_id_foreign');
		});
	}
}