<?php

namespace App\Models\Tenants;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Store extends Eloquent {

	protected $table = 'stores';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('company_id');
	protected $visible = array('company_id');

	public function company()
	{
		return $this->hasOne('App\Models\Tenants\Company', 'company_id');
	}

}