<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'first_name', 'last_name', 'email', 'phone', 'password', 'role_id', 'is_susbended');

    public function addresses()
    {
        return $this->morphMany('Address', 'addressable');
    }

    public function lookup()
    {
        return $this->belongsTo('Lookup');
    }

}