<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('about-us', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('testimonials', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('contact_us_massages', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('contact_us_massages', function(Blueprint $table) {
			$table->foreign('request_type')->references('id')->on('lookups')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('contact-details', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('lookups', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('lookups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('slider_items', function(Blueprint $table) {
			$table->foreign('slider_id')->references('id')->on('sliders')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('branch_service', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('branch_service', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('branch_client', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('branch_client', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('our-clients')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('about-us', function(Blueprint $table) {
			$table->dropForeign('about-us_branch_id_foreign');
		});
		Schema::table('testimonials', function(Blueprint $table) {
			$table->dropForeign('testimonials_branch_id_foreign');
		});
		Schema::table('contact_us_massages', function(Blueprint $table) {
			$table->dropForeign('contact_us_massages_branch_id_foreign');
		});
		Schema::table('contact_us_massages', function(Blueprint $table) {
			$table->dropForeign('contact_us_massages_request_type_foreign');
		});
		Schema::table('contact-details', function(Blueprint $table) {
			$table->dropForeign('contact-details_branch_id_foreign');
		});
		Schema::table('lookups', function(Blueprint $table) {
			$table->dropForeign('lookups_parent_id_foreign');
		});
		Schema::table('slider_items', function(Blueprint $table) {
			$table->dropForeign('slider_items_slider_id_foreign');
		});
		Schema::table('branch_service', function(Blueprint $table) {
			$table->dropForeign('branch_service_branch_id_foreign');
		});
		Schema::table('branch_service', function(Blueprint $table) {
			$table->dropForeign('branch_service_service_id_foreign');
		});
		Schema::table('branch_client', function(Blueprint $table) {
			$table->dropForeign('branch_client_branch_id_foreign');
		});
		Schema::table('branch_client', function(Blueprint $table) {
			$table->dropForeign('branch_client_client_id_foreign');
		});
	}
}