<?php

namespace Produit;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Produit extends Model 
{

    protected $table = 'produits';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function produitPrix()
    {
        return $this->hasMany('ProduitPrix');
    }

    public function produitSoldePrix()
    {
        return $this->hasMany('ProduitSoldePrix');
    }

    public function produitQuantiter()
    {
        return $this->hasMany('ProduitQuantiter');
    }

    public function produitNote()
    {
        return $this->hasMany('ProduitNote');
    }

    public function produitCommandeDetails()
    {
        return $this->hasMany('CommandeDetails');
    }

}