<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('SNomUsers', 255);
			$table->string('SPrenomUsers', 255);
			$table->string('SLoginUsers', 255);
			$table->string('password', 255);
			$table->string('SMailUsers', 255);
			$table->string('SAdresseUsers', 255);
			$table->string('STelephoneUsers', 255);
			$table->enum('ETypeUsers', array('root', 'admin', 'membre', 'other'));
			$table->string('remember_token', 255);
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}