<?php

namespace User;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function userProduit()
	{
		return $this->hasMany('Produit');
	}

	public function userCommande()
	{
		return $this->hasMany('Commande');
	}

	public function userCategorie()
	{
		return $this->hasMany('Categorie');
	}

	public function userProduitPrix()
	{
		return $this->hasMany('ProduitPrix');
	}

	public function userProduitSoldePrix()
	{
		return $this->hasMany('ProduitSoldePrix');
	}

	public function userProduitQuantiter()
	{
		return $this->hasMany('ProduitQuantiter');
	}

}