<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompaniesTable extends Migration {

	public function up()
	{
		Schema::create('companies', function(Blueprint $table) {
			$table->increments('id');
			$table->text('logo');
			$table->text('name');
			$table->text('public_email');
			$table->text('phone');
			$table->text('site_url');
			$table->boolean('is_confirmed')->default(0);
			$table->timestamps();
			$table->integer('user_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('companies');
	}
}