<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDepartmentsTable extends Migration {

	public function up()
	{
		Schema::create('departments', function(Blueprint $table) {
			$table->increments('id');
			$table->text('name');
			$table->text('photo');
			$table->text('phone');
			$table->text('email');
			$table->text('description');
			$table->double('latitude');
			$table->double('longitude');
			$table->text('site_url');
			$table->integer('company_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('departments');
	}
}