<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCitiesTable extends Migration {

	public function up()
	{
		Schema::create('cities', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 191)->nullable();
			$table->integer('parent_id')->unsigned();
			$table->enum('type', array('country', 'area', 'city'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('cities');
	}
}