<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSubscriptionsTable extends Migration {

	public function up()
	{
		Schema::create('subscriptions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 191)->nullable();
			$table->integer('ad_numbers')->nullable();
			$table->integer('cv_count')->nullable();
			$table->string('price', 191)->nullable();
			$table->enum('website_interview', array('true', 'false'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('subscriptions');
	}
}