<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('fullname', 191)->nullable();
			$table->string('username', 191)->nullable();
			$table->string('password', 191)->nullable();
			$table->enum('type', array('admin', 'worker', 'company'))->nullable();
			$table->integer('city_id')->unsigned()->nullable();
			$table->enum('gender', array('male', 'female'))->nullable();
			$table->text('address')->nullable();
			$table->string('mobile', 191)->nullable();
			$table->string('email', 191)->unique()->nullable();
			$table->enum('status', array('active', 'not_active'))->nullable();
			$table->enum('mobile_approved', array('true', 'false'))->nullable();
			$table->enum('vip', array('true', 'false'))->nullable();
			$table->string('website_link', 191)->nullable();
			$table->date('birthday')->nullable();
			$table->integer('nationality_id')->unsigned()->nullable();
			$table->integer('disability_id')->unsigned()->nullable();
			$table->integer('current_subscription_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}