<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWorkersTable extends Migration {

	public function up()
	{
		Schema::create('workers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->unsigned();
			$table->enum('hired', array('true', 'false'))->nullable();
			$table->enum('social_affairs', array('true', 'false'))->nullable();
			$table->enum('social_warranty', array('true', 'false'))->nullable();
			$table->string('height', 191)->nullable();
			$table->string('weight', 191)->nullable();
			$table->string('first_language')->nullable();
			$table->enum('firs_language_skill', array('weak', 'acceptable', 'good', 'very_good', 'excellent', 'undefined'))->nullable();
			$table->string('second_language', 191)->nullable();
			$table->enum('second_language_skill', array('weak', 'acceptable', 'good', 'very_good', 'excellent', 'undefined'))->nullable();
			$table->enum('licence', array('true', 'false', 'undefined'))->nullable();
			$table->string('licence_type', 191)->nullable();
			$table->enum('social_status', array('single', 'separated', 'divorced', 'widower', 'married'))->nullable();
			$table->integer('children')->nullable();
			$table->enum('works_before', array('true', 'false'))->nullable();
			$table->string('last_salary', 191)->nullable();
			$table->string('last_salary_currency', 191)->nullable();
			$table->string('university', 191)->nullable();
			$table->string('college', 191)->nullable();
			$table->date('graduate_year')->nullable();
			$table->enum('graduate_degree', array('acceptable', 'good', 'very_good', 'excellent', 'undefined'))->nullable();
			$table->integer('last_degree_id')->unsigned()->nullable();
			$table->text('about_description')->nullable();
			$table->text('courses_desc')->nullable();
			$table->string('resume', 191)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('workers');
	}
}