<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePreferedJobsTable extends Migration {

	public function up()
	{
		Schema::create('prefered_jobs', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->unsigned()->nullable();
			$table->json('countries')->nullable();
			$table->string('job_title', 191)->nullable();
			$table->integer('job_category_id')->unsigned();
			$table->enum('job_system', array('undefined', 'trainer', 'contractor', 'temporary', 'full_time', 'remotely'))->nullable();
			$table->string('salary', 191)->nullable();
			$table->string('salary_currency', 191)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('prefered_jobs');
	}
}