<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('nationality_id')->references('id')->on('cities')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('disability_id')->references('id')->on('disabilities')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('current_subscription_id')->references('id')->on('subscriptions')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('workers', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('cities')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('jobs', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('jobs', function(Blueprint $table) {
			$table->foreign('disability_id')->references('id')->on('categories')
						->onDelete('no action')
						->onUpdate('restrict');
		});
		Schema::table('jobs', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('jobs', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('jobs', function(Blueprint $table) {
			$table->foreign('settledown_country_id')->references('id')->on('cities')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('jobs', function(Blueprint $table) {
			$table->foreign('nationality_id')->references('id')->on('cities')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('jobs', function(Blueprint $table) {
			$table->foreign('education_id')->references('id')->on('educations')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('user_docs', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('contacts', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('cities')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('user_experiences', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('user_experiences', function(Blueprint $table) {
			$table->foreign('company_field_id')->references('id')->on('categories')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('user_experiences', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('prefered_jobs', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('prefered_jobs', function(Blueprint $table) {
			$table->foreign('job_category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('user_skills', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('job_history', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('worker_interests', function(Blueprint $table) {
			$table->foreign('worker_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('worker_interests', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('worker_ignores', function(Blueprint $table) {
			$table->foreign('worker_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('worker_ignores', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('appointment_request', function(Blueprint $table) {
			$table->foreign('worker_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('appointment_request', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('company_subscriptions', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('company_subscriptions', function(Blueprint $table) {
			$table->foreign('subscription_id')->references('id')->on('subscriptions')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->foreign('room_id')->references('id')->on('rooms')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->foreign('sender_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->foreign('receiver_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('rooms', function(Blueprint $table) {
			$table->foreign('sender_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('rooms', function(Blueprint $table) {
			$table->foreign('receiver_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('favourites', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('favourites', function(Blueprint $table) {
			$table->foreign('job_id')->references('id')->on('jobs')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('resumes', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('resumes', function(Blueprint $table) {
			$table->foreign('disability_id')->references('id')->on('disabilities')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('resume_qualifications', function(Blueprint $table) {
			$table->foreign('resume_id')->references('id')->on('resumes')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('resume_experiences', function(Blueprint $table) {
			$table->foreign('resume_id')->references('id')->on('resumes')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('resume_courses', function(Blueprint $table) {
			$table->foreign('resume_id')->references('id')->on('resumes')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('resume_skills', function(Blueprint $table) {
			$table->foreign('resume_id')->references('id')->on('resumes')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('applied_jobs', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('applied_jobs', function(Blueprint $table) {
			$table->foreign('job_id')->references('id')->on('jobs')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_city_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_nationality_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_disability_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_current_subscription_id_foreign');
		});
		Schema::table('workers', function(Blueprint $table) {
			$table->dropForeign('workers_user_id_foreign');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->dropForeign('companies_user_id_foreign');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->dropForeign('cities_parent_id_foreign');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->dropForeign('categories_parent_id_foreign');
		});
		Schema::table('jobs', function(Blueprint $table) {
			$table->dropForeign('jobs_category_id_foreign');
		});
		Schema::table('jobs', function(Blueprint $table) {
			$table->dropForeign('jobs_disability_id_foreign');
		});
		Schema::table('jobs', function(Blueprint $table) {
			$table->dropForeign('jobs_city_id_foreign');
		});
		Schema::table('jobs', function(Blueprint $table) {
			$table->dropForeign('jobs_company_id_foreign');
		});
		Schema::table('jobs', function(Blueprint $table) {
			$table->dropForeign('jobs_settledown_country_id_foreign');
		});
		Schema::table('jobs', function(Blueprint $table) {
			$table->dropForeign('jobs_nationality_id_foreign');
		});
		Schema::table('jobs', function(Blueprint $table) {
			$table->dropForeign('jobs_education_id_foreign');
		});
		Schema::table('user_docs', function(Blueprint $table) {
			$table->dropForeign('user_docs_user_id_foreign');
		});
		Schema::table('contacts', function(Blueprint $table) {
			$table->dropForeign('contacts_country_id_foreign');
		});
		Schema::table('user_experiences', function(Blueprint $table) {
			$table->dropForeign('user_experiences_user_id_foreign');
		});
		Schema::table('user_experiences', function(Blueprint $table) {
			$table->dropForeign('user_experiences_company_field_id_foreign');
		});
		Schema::table('user_experiences', function(Blueprint $table) {
			$table->dropForeign('user_experiences_city_id_foreign');
		});
		Schema::table('prefered_jobs', function(Blueprint $table) {
			$table->dropForeign('prefered_jobs_user_id_foreign');
		});
		Schema::table('prefered_jobs', function(Blueprint $table) {
			$table->dropForeign('prefered_jobs_job_category_id_foreign');
		});
		Schema::table('user_skills', function(Blueprint $table) {
			$table->dropForeign('user_skills_user_id_foreign');
		});
		Schema::table('job_history', function(Blueprint $table) {
			$table->dropForeign('job_history_user_id_foreign');
		});
		Schema::table('worker_interests', function(Blueprint $table) {
			$table->dropForeign('worker_interests_worker_id_foreign');
		});
		Schema::table('worker_interests', function(Blueprint $table) {
			$table->dropForeign('worker_interests_company_id_foreign');
		});
		Schema::table('worker_ignores', function(Blueprint $table) {
			$table->dropForeign('worker_ignores_worker_id_foreign');
		});
		Schema::table('worker_ignores', function(Blueprint $table) {
			$table->dropForeign('worker_ignores_company_id_foreign');
		});
		Schema::table('appointment_request', function(Blueprint $table) {
			$table->dropForeign('appointment_request_worker_id_foreign');
		});
		Schema::table('appointment_request', function(Blueprint $table) {
			$table->dropForeign('appointment_request_company_id_foreign');
		});
		Schema::table('company_subscriptions', function(Blueprint $table) {
			$table->dropForeign('company_subscriptions_company_id_foreign');
		});
		Schema::table('company_subscriptions', function(Blueprint $table) {
			$table->dropForeign('company_subscriptions_subscription_id_foreign');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->dropForeign('messages_room_id_foreign');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->dropForeign('messages_sender_id_foreign');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->dropForeign('messages_receiver_id_foreign');
		});
		Schema::table('rooms', function(Blueprint $table) {
			$table->dropForeign('rooms_sender_id_foreign');
		});
		Schema::table('rooms', function(Blueprint $table) {
			$table->dropForeign('rooms_receiver_id_foreign');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->dropForeign('notifications_user_id_foreign');
		});
		Schema::table('favourites', function(Blueprint $table) {
			$table->dropForeign('favourites_user_id_foreign');
		});
		Schema::table('favourites', function(Blueprint $table) {
			$table->dropForeign('favourites_job_id_foreign');
		});
		Schema::table('resumes', function(Blueprint $table) {
			$table->dropForeign('resumes_user_id_foreign');
		});
		Schema::table('resumes', function(Blueprint $table) {
			$table->dropForeign('resumes_disability_id_foreign');
		});
		Schema::table('resume_qualifications', function(Blueprint $table) {
			$table->dropForeign('resume_qualifications_resume_id_foreign');
		});
		Schema::table('resume_experiences', function(Blueprint $table) {
			$table->dropForeign('resume_experiences_resume_id_foreign');
		});
		Schema::table('resume_courses', function(Blueprint $table) {
			$table->dropForeign('resume_courses_resume_id_foreign');
		});
		Schema::table('resume_skills', function(Blueprint $table) {
			$table->dropForeign('resume_skills_resume_id_foreign');
		});
		Schema::table('applied_jobs', function(Blueprint $table) {
			$table->dropForeign('applied_jobs_user_id_foreign');
		});
		Schema::table('applied_jobs', function(Blueprint $table) {
			$table->dropForeign('applied_jobs_job_id_foreign');
		});
	}
}