<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBannersTable extends Migration {

	public function up()
	{
		Schema::create('banners', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title', 191)->nullable();
			$table->string('image', 191)->nullable();
			$table->string('url', 191)->nullable();
			$table->enum('position', array('big', 'medium', 'small'))->nullable();
			$table->text('notes')->nullable();
			$table->enum('status', array('active', 'not_active'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('banners');
	}
}