<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMessagesTable extends Migration {

	public function up()
	{
		Schema::create('messages', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('room_id')->unsigned();
			$table->integer('sender_id')->unsigned();
			$table->integer('receiver_id')->unsigned();
			$table->text('message')->nullable();
			$table->enum('seen', array('true', 'false'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('messages');
	}
}