<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePagesTable extends Migration {

	public function up()
	{
		Schema::create('pages', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title', 191)->nullable();
			$table->text('body')->nullable();
			$table->enum('flag', array('term', 'about', 'company_register', 'privacy', 'employment_laws', 'conditionals', 'vip'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('pages');
	}
}