<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRoomsTable extends Migration {

	public function up()
	{
		Schema::create('rooms', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 191)->nullable();
			$table->datetime('date')->nullable();
			$table->enum('open', array('open', 'close'))->nullable();
			$table->integer('sender_id')->unsigned();
			$table->integer('receiver_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('rooms');
	}
}