<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSettingsTable extends Migration {

	public function up()
	{
		Schema::create('settings', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('email', 191)->nullable();
			$table->string('site_name', 191)->nullable();
			$table->text('meta_tags')->nullable();
			$table->text('search_words')->nullable();
			$table->string('twitter', 191)->nullable();
			$table->string('youtube', 191)->nullable();
			$table->string('facebook', 191)->nullable();
			$table->text('job_condition')->nullable();
			$table->string('video', 191)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('settings');
	}
}