<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBidsTable extends Migration {

	public function up()
	{
		Schema::create('bids', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('fk_consolidated_demands_id');
			$table->integer('fk_users_acc_id');
			$table->tinyInteger('status');
			$table->integer('fk_planting_plan');
			$table->float('qty', 10,2);
			$table->integer('fk_batch_bids_id');
			$table->string('amount_receivable');
			$table->integer('fk_planting_plan_id');
		});
	}

	public function down()
	{
		Schema::drop('bids');
	}
}