<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDemandsTable extends Migration {

	public function up()
	{
		Schema::create('demands', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('fk_users_acc_id');
			$table->integer('fk_crops_id');
			$table->float('qty');
			$table->datetime('proposed_delivery_date');
			$table->tinyInteger('status');
			$table->string('tracking_number', 7);
			$table->integer('fk_consolidated_demands_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('demands');
	}
}