<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFarmDetailsTable extends Migration {

	public function up()
	{
		Schema::create('farm_details', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('farm_name', 255);
			$table->float('farm_size', 10,2);
			$table->string('region', 100);
			$table->string('province', 100);
			$table->string('city', 100);
			$table->string('brgy', 100);
			$table->string('long', 100)->nullable();
			$table->string('lat', 100)->nullable();
			$table->integer('fk_users_details_id');
		});
	}

	public function down()
	{
		Schema::drop('farm_details');
	}
}