<?php

namespace Users_Details;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Users_Details extends Model 
{

    protected $table = 'users_details';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function entity_details()
    {
        return $this->hasOne('Entity_Details', 'id', 'fk_entity_details');
    }

    public function farm_details()
    {
        return $this->hasOne('Farm_Details', 'id', 'fk_farm_details');
    }

}