<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('crops', function(Blueprint $table) {
			$table->foreign('fk_crop_pricing_id')->references('id')->on('crop_pricing')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('crop_records', function(Blueprint $table) {
			$table->foreign('fk_crop_id')->references('id')->on('crops')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('crops', function(Blueprint $table) {
			$table->dropForeign('crops_fk_crop_pricing_id_foreign');
		});
		Schema::table('crop_records', function(Blueprint $table) {
			$table->dropForeign('crop_records_fk_crop_id_foreign');
		});
	}
}