<?php

namespace Batch_Checked_Out;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Batch_Checked_Out extends Eloquent {

	protected $table = 'batch_checked_out';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function checked_out_demands()
	{
		return $this->hasMany('Checked_Out_Demands', 'batch_tracking_number', 'fk_batch_tracking_number');
	}

}