<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateConsolidatedDemandsTable extends Migration {

	public function up()
	{
		Schema::create('consolidated_demands', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->float('total_amount_fgp', 10,2);
			$table->float('total_amount_srp', 10,2);
			$table->string('consolidated_demands_control_number', 255);
			$table->float('total_remaining_qty', 10,2);
			$table->integer('fk_crops_id');
			$table->string('status', 15);
			$table->string('tracking_number', 11);
			$table->string('class', 255);
			$table->date('proposed_delivery_date');
		});
	}

	public function down()
	{
		Schema::drop('consolidated_demands');
	}
}