<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCropsTable extends Migration {

	public function up()
	{
		Schema::create('crops', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 255);
			$table->float('qty');
			$table->string('unit', 50);
			$table->string('class', 10);
			$table->string('seasonality', 255);
			$table->string('crop_type', 50);
			$table->integer('fk_crop_pricing_id')->unsigned();
			$table->integer('fk_crop_production_id');
			$table->integer('fk_varieties_id');
			$table->integer('fk_crop_classes_id');
		});
	}

	public function down()
	{
		Schema::drop('crops');
	}
}