<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEntityDetailsTable extends Migration {

	public function up()
	{
		Schema::create('entity_details', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('entity_name', 255)->nullable();
			$table->string('nature_of_entity', 255)->nullable();
			$table->string('business_permit_no', 255)->nullable();
			$table->string('region', 100);
			$table->string('province', 100);
			$table->string('city', 100);
			$table->string('brgy', 100);
			$table->string('long', 255);
			$table->string('lat', 255);
			$table->integer('fk_users_details_id');
		});
	}

	public function down()
	{
		Schema::drop('entity_details');
	}
}