<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Ov extends Model 
{

    protected $table = 'ov';
    public $timestamps = true;
    protected $fillable = array('ovVersion', 'ovMacAddress', 'uploadTime', 'ovId', 'ovmId', 'ovmVersion', 'subscriptionId', 'networkPollTime', 'ovIpAddress', 'ovManagedVMs', 'ovPlatform');
    protected $hidden = array('timestamps');

    public function equipments()
    {
        return $this->hasMany('Equipment', 'id_ov_foreign_key');
    }

    public function licenses()
    {
        return $this->hasMany('License', 'id_ov_foreign_key');
    }

}