<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 191)->nullable();
			$table->string('email', 191)->unique()->nullable();
			$table->string('mobile', 191)->unique()->nullable();
			$table->string('password', 191)->nullable();
			$table->integer('city_id')->unsigned();
			$table->string('image', 191)->nullable();
			$table->enum('type', array('user', 'admin'))->nullable();
			$table->enum('status', array('active', 'not_active'))->nullable();
			$table->string('code', 191)->nullable();
			$table->enum('verified', array('true', 'false'))->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}