<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;

class Report extends Model 
{

    protected $table = 'reports';
    public $timestamps = true;
    protected $fillable = array('user_id', 'comment_id', 'auction_id', 'body');

    public function user()
    {
        return $this->belongsTo('\User', 'user_id');
    }

    public function comment()
    {
        return $this->belongsTo('Models\Comment', 'comment_id');
    }

    public function auction()
    {
        return $this->belongsTo('Models\Auction', 'auction_id');
    }

}