<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAuctionTable extends Migration {

	public function up()
	{
		Schema::create('auction', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title', 191)->nullable();
			$table->date('start_date')->nullable();
			$table->date('end_date')->nullable();
			$table->text('description')->nullable();
			$table->string('start_price', 191)->nullable();
			$table->string('last_price', 191)->nullable();
			$table->integer('count')->unsigned()->nullable();
			$table->integer('user_id')->unsigned();
			$table->integer('city_id')->unsigned();
			$table->enum('type', array('limit', 'open', 'request'))->nullable();
			$table->integer('winner_id')->unsigned();
			$table->integer('category_id')->unsigned();
			$table->text('address')->nullable();
			$table->enum('status', array('active', 'not_active'))->nullable();
			$table->enum('auction_status', array('ongoing', 'finished'))->nullable();
			$table->string('id_firebase', 191)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('auction');
	}
}