<?php

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;
	protected $fillable = array('name', 'email', 'mobile', 'password', 'city_id', 'image', 'type', 'status', 'code', 'verified');

	public function city()
	{
		return $this->belongsTo('Models\City', 'city_id');
	}

	public function tokens()
	{
		return $this->hasMany('Models\Token', 'user_id');
	}

	public function auctions()
	{
		return $this->hasMany('Models\Auction', 'user_id');
	}

	public function winner_auctions()
	{
		return $this->hasMany('Models\Auction', 'winner_id');
	}

	public function categories()
	{
		return $this->belongsToMany('Models\Category', 'interests', 'user_id', 'category_id');
	}

	public function comments()
	{
		return $this->hasMany('Models\Comment', 'user_id');
	}

	public function favourites()
	{
		return $this->belongsToMany('Models\Auction', 'favourites', 'user_id', 'auction_id');
	}

	public function reports()
	{
		return $this->hasMany('Models\Report', 'user_id');
	}

}