<?php

namespace App;

class Customer extends Eloquent {

	protected $table = 'customers';
	public $timestamps = false;
	protected $fillable = array('firstname', 'lastname', 'staff_id', 'balance');

	public function orders()
	{
		return $this->hasMany('App\Order');
	}

	public function staff()
	{
		return $this->belongsTo('App\Staff');
	}

	public function menus()
	{
		return $this->belongsToMany('App\Menu')->withPivot('id')->withTimestamps();
	}

}