<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateKfetTable extends Migration {

	public function up()
	{
		Schema::create('kfet', function(Blueprint $table) {
			$table->increments('id');
			$table->float('balance')->default('0');
			$table->integer('reason_id')->nullable();
			$table->string('reason_table', 255)->nullable();
			$table->timestamp('timestamps');
			$table->enum('reason_type', array('INSERT', 'UPDATE', 'DELETE', 'DISCOUNT'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('kfet');
	}
}