<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSessionsTable extends Migration {

	public function up()
	{
		Schema::create('sessions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id');
			$table->string('ip_address', 45);
			$table->text('user_agent');
			$table->text('payload');
			$table->timestamp('last_activity');
		});
	}

	public function down()
	{
		Schema::drop('sessions');
	}
}