<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Post extends Model 
{

    protected $table = 'post';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function user()
    {
        return $this->belongsTo('App\User', 'user');
    }

    public function catRelation()
    {
        return $this->hasMany('App\PostRelationship', 'post');
    }

    public function comments()
    {
        return $this->hasMany('App\Comment', 'post');
    }

}