<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Category extends Eloquent {

	protected $table = 'category';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function parent()
	{
		return $this->belongsTo('App\Category', 'parent');
	}

	public function postRelation()
	{
		return $this->hasMany('App\PostRelationship', 'category');
	}

}