<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('post', function(Blueprint $table) {
			$table->foreign('user')->references('id')->on('user')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('category', function(Blueprint $table) {
			$table->foreign('parent')->references('id')->on('category')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('comment', function(Blueprint $table) {
			$table->foreign('post')->references('id')->on('post')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('comment', function(Blueprint $table) {
			$table->foreign('user')->references('id')->on('user')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('post_relationship', function(Blueprint $table) {
			$table->foreign('post')->references('id')->on('post')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('post_relationship', function(Blueprint $table) {
			$table->foreign('category')->references('id')->on('category')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('post', function(Blueprint $table) {
			$table->dropForeign('post_user_foreign');
		});
		Schema::table('category', function(Blueprint $table) {
			$table->dropForeign('category_parent_foreign');
		});
		Schema::table('comment', function(Blueprint $table) {
			$table->dropForeign('comment_post_foreign');
		});
		Schema::table('comment', function(Blueprint $table) {
			$table->dropForeign('comment_user_foreign');
		});
		Schema::table('post_relationship', function(Blueprint $table) {
			$table->dropForeign('post_relationship_post_foreign');
		});
		Schema::table('post_relationship', function(Blueprint $table) {
			$table->dropForeign('post_relationship_category_foreign');
		});
	}
}