<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSubscriptionsTable extends Migration {

	public function up()
	{
		Schema::create('subscriptions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('client_id');
			$table->string('software_serial');
			$table->date('date');
			$table->string('domain');
			$table->float('price', 10,2);
			$table->integer('agent_id');
			$table->float('agent_percentage', 10,2);
			$table->float('net_price', 10,2);
			$table->integer('payment_method');
			$table->integer('payment_status');
			$table->date('payment_date');
			$table->string('renew');
		});
	}

	public function down()
	{
		Schema::drop('subscriptions');
	}
}