<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInstrumentsTable extends Migration {

	public function up()
	{
		Schema::create('instruments', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('slug')->unique();
			$table->string('type')->nullable();
			$table->text('description')->nullable();
			$table->string('validity')->nullable();
			$table->string('average_usage_duration')->nullable();
			$table->text('usage_explanation');
			$table->boolean('in_dutch')->nullable();
			$table->string('get_it_from_label')->nullable();
			$table->string('get_it_from_url')->nullable();
			$table->datetime('published_at')->nullable();
			$table->integer('published_by')->unsigned()->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('instruments');
	}
}