<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('instruments', function(Blueprint $table) {
			$table->foreign('published_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('literatures', function(Blueprint $table) {
			$table->foreign('publisher_id')->references('id')->on('publishers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('literatures', function(Blueprint $table) {
			$table->foreign('source_type_id')->references('id')->on('source_types')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('literatures', function(Blueprint $table) {
			$table->foreign('source_literature_id')->references('id')->on('literatures')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('literatures', function(Blueprint $table) {
			$table->foreign('published_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('literature_publisher', function(Blueprint $table) {
			$table->foreign('literature_id')->references('id')->on('literatures')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('literature_publisher', function(Blueprint $table) {
			$table->foreign('publisher_id')->references('id')->on('publishers')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('instrument_literature', function(Blueprint $table) {
			$table->foreign('instrument_id')->references('id')->on('instruments')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('instrument_literature', function(Blueprint $table) {
			$table->foreign('literature_id')->references('id')->on('literatures')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('literature_author', function(Blueprint $table) {
			$table->foreign('literature_id')->references('id')->on('literatures')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('literature_author', function(Blueprint $table) {
			$table->foreign('author_id')->references('id')->on('authors')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('instruments', function(Blueprint $table) {
			$table->dropForeign('instruments_published_by_foreign');
		});
		Schema::table('literatures', function(Blueprint $table) {
			$table->dropForeign('literatures_publisher_id_foreign');
		});
		Schema::table('literatures', function(Blueprint $table) {
			$table->dropForeign('literatures_source_type_id_foreign');
		});
		Schema::table('literatures', function(Blueprint $table) {
			$table->dropForeign('literatures_source_literature_id_foreign');
		});
		Schema::table('literatures', function(Blueprint $table) {
			$table->dropForeign('literatures_published_by_foreign');
		});
		Schema::table('literature_publisher', function(Blueprint $table) {
			$table->dropForeign('literature_publisher_literature_id_foreign');
		});
		Schema::table('literature_publisher', function(Blueprint $table) {
			$table->dropForeign('literature_publisher_publisher_id_foreign');
		});
		Schema::table('instrument_literature', function(Blueprint $table) {
			$table->dropForeign('instrument_literature_instrument_id_foreign');
		});
		Schema::table('instrument_literature', function(Blueprint $table) {
			$table->dropForeign('instrument_literature_literature_id_foreign');
		});
		Schema::table('literature_author', function(Blueprint $table) {
			$table->dropForeign('literature_author_literature_id_foreign');
		});
		Schema::table('literature_author', function(Blueprint $table) {
			$table->dropForeign('literature_author_author_id_foreign');
		});
	}
}