<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('app_producthit', function(Blueprint $table) {
			$table->foreign('product_id')->references('ID')->on('posts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('app_hitquestionnaire', function(Blueprint $table) {
			$table->foreign('producthit_id')->references('producthit_id')->on('app_producthit')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('app_question', function(Blueprint $table) {
			$table->foreign('hitquestionnaire_id')->references('hitquestionnaire_id')->on('app_hitquestionnaire')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('app_producthit', function(Blueprint $table) {
			$table->dropForeign('app_producthit_product_id_foreign');
		});
		Schema::table('app_hitquestionnaire', function(Blueprint $table) {
			$table->dropForeign('app_hitquestionnaire_producthit_id_foreign');
		});
		Schema::table('app_question', function(Blueprint $table) {
			$table->dropForeign('app_question_hitquestionnaire_id_foreign');
		});
	}
}