<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateHmoFormPropertyOwnershipTable extends Migration {

	public function up()
	{
		Schema::create('hmo_form_property_ownership', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('hmo_form_id')->unsigned();
			$table->integer('property_ownership_type_id')->unsigned()->nullable();
			$table->string('name');
			$table->string('email')->nullable();
			$table->string('telephone')->nullable();
			$table->string('company_name')->nullable();
			$table->string('job_position')->nullable();
			$table->string('interest_in_property', 255)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('hmo_form_property_ownership');
	}
}