<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAddressesTable extends Migration {

	public function up()
	{
		Schema::create('addresses', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('addressable_id');
			$table->string('addressable_type');
			$table->string('uprn')->nullable();
			$table->string('address_1');
			$table->string('address_2')->nullable();
			$table->string('address_3')->nullable();
			$table->string('town_city');
			$table->string('postcode');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('addresses');
	}
}