<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Truck extends Model 
{

    protected $table = 'trucks';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('model', 'plate', 'capacity', 'year', 'transporter_id', 'axe_id', 'truck_uses_id', 'state_id', 'truck_structure_id', 'image');

    public function charges()
    {
        return $this->belongsToMany('App\Charge', 'charge_id');
    }

    public function transporters()
    {
        return $this->belongsToMany('App\Transporter', 'transporter_id');
    }

}